/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.catnip.gui.render.PartialRenderState;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.model.LayerBakedModel;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11239;
import net.minecraft.class_11241;
import net.minecraft.class_11246;
import net.minecraft.class_11515;
import net.minecraft.class_12137;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;

@Environment(value=EnvType.CLIENT)
public class PartialElementRenderer
extends class_11239<PartialRenderState> {
    private static final Map<PartialRenderState, GpuTexture> TEXTURES = new IdentityHashMap<PartialRenderState, GpuTexture>();
    private final class_4587 matrices = new class_4587();
    private int windowScaleFactor;

    public PartialElementRenderer(class_4597.class_4598 vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(PartialRenderState block) {
        GpuTexture texture = TEXTURES.remove(block);
        if (texture != null) {
            texture.close();
        }
    }

    public void prepare(PartialRenderState partial, class_11246 state, int windowScaleFactor) {
        GpuTexture texture;
        boolean draw;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        boolean bl = draw = (texture = TEXTURES.get(partial)) == null || partial.dirty;
        if (draw) {
            float size = partial.size * (float)windowScaleFactor;
            if (partial.dirty) {
                partial.clearDirty();
                if (texture != null && (float)texture.width() != size) {
                    texture.close();
                    texture = null;
                }
            }
            if (texture == null) {
                texture = GpuTexture.create((int)size);
                TEXTURES.put(partial, texture);
            }
            texture.prepare(this.field_60042);
            this.matrices.method_22903();
            if (partial.padding != 0) {
                size -= (float)(partial.padding * windowScaleFactor);
            }
            this.matrices.method_22905(size, size, size);
            partial.transform(this.matrices);
            class_310 mc = class_310.method_1551();
            class_11515 blockRenderLayer = LayerBakedModel.getBlockRenderLayer(partial.model, (Supplier<class_11515>)((Supplier)() -> class_11515.field_60923));
            class_1921 layer = blockRenderLayer == class_11515.field_60926 ? class_4722.method_29382() : class_4722.method_24074();
            SinglePosVirtualBlockGetter world = SinglePosVirtualBlockGetter.createFullBright();
            mc.method_1541().method_3355(class_2246.field_10124.method_9564(), class_2338.field_10980, (class_1920)world, this.matrices, this.field_59933.method_73477(layer), false, List.of(partial.model));
            this.field_59933.method_22993();
            this.matrices.method_22909();
            texture.clear();
        }
        state.method_71996(new class_11241(class_10799.field_59968, class_11231.method_70900((GpuTextureView)texture.textureView(), (class_12137)RenderSystem.getSamplerCache().method_75297(FilterMode.NEAREST)), partial.pose, partial.x1, partial.y1, partial.x2, partial.y2, 0.0f, 1.0f, 1.0f, 0.0f, -1, partial.scissor, null));
    }

    protected void renderToTexture(PartialRenderState partial, class_4587 matrices) {
    }

    protected String method_70906() {
        return "Partial";
    }

    public Class<PartialRenderState> method_70903() {
        return PartialRenderState.class;
    }
}

